/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.buildings.modules.IMinimumStockModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.client.gui.WindowSelectRes;
import com.minecolonies.coremod.network.messages.server.colony.building.AddMinimumStockToBuildingModuleMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.RemoveMinimumStockFromBuildingModuleMessage;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class MinimumStockModuleWindow
extends AbstractModuleWindow {
    private static final String RESOURCE_STRING = ":gui/layouthuts/layoutminimumstock.xml";
    private static final String LABEL_LIMIT_REACHED = "com.minecolonies.coremod.gui.warehouse.limitreached";
    private final ScrollingList resourceList;
    private final IMinimumStockModuleView moduleView;

    public MinimumStockModuleWindow(IBuildingView building, IMinimumStockModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutminimumstock.xml");
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resourcesstock", ScrollingList.class);
        this.moduleView = moduleView;
        this.registerButton("addStock", this::addStock);
        if (moduleView.hasReachedLimit()) {
            ButtonImage button = (ButtonImage)this.findPaneOfTypeByID("addStock", ButtonImage.class);
            button.setText(LanguageHandler.format((String)LABEL_LIMIT_REACHED, (Object[])new Object[0]));
            button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_dark.png"));
        }
        this.registerButton("removeStock", this::removeStock);
    }

    private void removeStock(Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        Tuple<ItemStorage, Integer> tuple = this.moduleView.getStock().get(row);
        this.moduleView.getStock().remove(row);
        Network.getNetwork().sendToServer(new RemoveMinimumStockFromBuildingModuleMessage(this.buildingView, tuple.getA().getItemStack()));
        this.updateStockList();
    }

    private void addStock() {
        if (!this.moduleView.hasReachedLimit()) {
            new WindowSelectRes(this, this.buildingView, stack -> true, (stack, qty) -> Network.getNetwork().sendToServer(new AddMinimumStockToBuildingModuleMessage(this.buildingView, (ItemStack)stack, (int)qty)), true).open();
        }
    }

    public void onOpened() {
        super.onOpened();
        this.updateStockList();
    }

    private void updateStockList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return MinimumStockModuleWindow.this.moduleView.getStock().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = MinimumStockModuleWindow.this.moduleView.getStock().get(index).getA().getItemStack().func_77946_l();
                resource.func_190920_e(resource.func_77976_d());
                ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(resource.func_200301_q());
                ((Text)rowPane.findPaneOfTypeByID("resourceQty", Text.class)).setText(String.valueOf(MinimumStockModuleWindow.this.moduleView.getStock().get(index).getB()));
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }
}

